<?php
/**
 * API endpoint pentru căutarea canalelor
 * POST /api/channels/search
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once '../../config/database.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit();
}

$input = json_decode(file_get_contents('php://input'), true);
$search = $input['search'] ?? null;
$userId = $input['user_id'] ?? null;

if (!$search) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'search parameter is required'
    ]);
    exit();
}

try {
    $database = new Database();
    $db = $database->getConnection();
    
    if (!$db) {
        throw new Exception('Database connection failed');
    }
    
    $query = "
        SELECT 
            c.id,
            c.name,
            c.url,
            c.logo,
            c.category_id,
            cat.name as category,
            c.description,
            c.language,
            c.country,
            c.is_hd,
            c.epg_id,
            CASE WHEN f.id IS NOT NULL THEN 1 ELSE 0 END as is_favorite
        FROM channels c
        LEFT JOIN categories cat ON c.category_id = cat.id
        LEFT JOIN favorites f ON f.channel_id = c.id AND f.user_id = :user_id
        WHERE (c.name LIKE :search OR c.description LIKE :search_desc)
        ORDER BY c.name ASC
        LIMIT 100
    ";
    
    $searchTerm = "%{$search}%";
    
    $stmt = $db->prepare($query);
    $stmt->bindParam(':user_id', $userId, PDO::PARAM_INT);
    $stmt->bindParam(':search', $searchTerm, PDO::PARAM_STR);
    $stmt->bindParam(':search_desc', $searchTerm, PDO::PARAM_STR);
    $stmt->execute();
    
    $channels = $stmt->fetchAll();
    
    echo json_encode([
        'success' => true,
        'data' => $channels
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Server error: ' . $e->getMessage()
    ]);
}

