<?php
/**
 * API endpoint pentru obținerea playlist-ului M3U8
 * POST /api/playlist
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once '../config/database.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit();
}

$input = json_decode(file_get_contents('php://input'), true);
$userId = $input['user_id'] ?? null;
$token = $input['token'] ?? null;

try {
    $database = new Database();
    $db = $database->getConnection();
    
    if (!$db) {
        throw new Exception('Database connection failed');
    }
    
    // Obține playlist-ul pentru utilizator
    $query = "
        SELECT 
            p.id,
            p.name,
            p.m3u8_url as url,
            p.user_id,
            p.created_at
        FROM playlists p
        WHERE (p.user_id = :user_id OR p.user_id IS NULL)
        ORDER BY p.user_id DESC, p.created_at DESC
        LIMIT 1
    ";
    
    $stmt = $db->prepare($query);
    $stmt->bindParam(':user_id', $userId, PDO::PARAM_INT);
    $stmt->execute();
    
    $playlist = $stmt->fetch();
    
    if (!$playlist) {
        echo json_encode([
            'success' => false,
            'message' => 'No playlist found'
        ]);
        exit();
    }
    
    // Obține canalele
    $channelsQuery = "
        SELECT 
            c.id,
            c.name,
            c.url,
            c.logo,
            c.category_id,
            cat.name as category,
            c.description,
            c.language,
            c.country,
            c.is_hd,
            c.epg_id,
            CASE WHEN f.id IS NOT NULL THEN 1 ELSE 0 END as is_favorite
        FROM channels c
        LEFT JOIN categories cat ON c.category_id = cat.id
        LEFT JOIN favorites f ON f.channel_id = c.id AND f.user_id = :user_id
        WHERE c.playlist_id = :playlist_id
        ORDER BY c.name ASC
    ";
    
    $channelsStmt = $db->prepare($channelsQuery);
    $channelsStmt->bindParam(':user_id', $userId, PDO::PARAM_INT);
    $channelsStmt->bindParam(':playlist_id', $playlist['id'], PDO::PARAM_INT);
    $channelsStmt->execute();
    $channels = $channelsStmt->fetchAll();
    
    // Obține categoriile
    $categoriesQuery = "
        SELECT 
            cat.id,
            cat.name,
            cat.icon,
            COUNT(c.id) as channel_count
        FROM categories cat
        LEFT JOIN channels c ON c.category_id = cat.id AND c.playlist_id = :playlist_id
        WHERE cat.playlist_id = :playlist_id
        GROUP BY cat.id, cat.name, cat.icon
        ORDER BY cat.name ASC
    ";
    
    $categoriesStmt = $db->prepare($categoriesQuery);
    $categoriesStmt->bindParam(':playlist_id', $playlist['id'], PDO::PARAM_INT);
    $categoriesStmt->execute();
    $categories = $categoriesStmt->fetchAll();
    
    $playlist['channels'] = $channels;
    $playlist['categories'] = $categories;
    
    echo json_encode([
        'success' => true,
        'data' => $playlist
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Server error: ' . $e->getMessage()
    ]);
}

