<?php
/**
 * Example configuration file
 * Copy this to config/database.php and update with your credentials
 */

class Database {
    // Update these with your MySQL credentials
    private $host = 'localhost';
    private $db_name = 'zapplay_tv';
    private $username = 'your_username';
    private $password = 'your_password';
    private $conn;
    
    public function getConnection() {
        $this->conn = null;
        
        try {
            $this->conn = new PDO(
                "mysql:host=" . $this->host . ";dbname=" . $this->db_name . ";charset=utf8mb4",
                $this->username,
                $this->password
            );
            $this->conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->conn->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
        } catch(PDOException $e) {
            error_log("Connection Error: " . $e->getMessage());
        }
        
        return $this->conn;
    }
}

